using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Security
{
    public delegate bool ValidateCredentialsDelegate(string userName, string password);

    public partial class LoginPrompt : Form
    {
        private ValidateCredentialsDelegate credValidator = null;
        private bool validationResult = false;

        public LoginPrompt()
        {
            InitializeComponent();
        }

        public LoginPrompt(ValidateCredentialsDelegate del)
        {
            InitializeComponent();
            credValidator = del;
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            if (credValidator != null)
                validationResult = credValidator(txtUserName.Text, txtPassword.Text);
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        public bool ValidationResult
        {
            get { return validationResult; }
            set { validationResult = value; }
        }
    }
}
